<?php

/* 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * Original random block code from gallery.menalto.com
 * This updated version (c) 2003 Dariush Molavi
 * dari.molavi@nukedgallery.net
 * Version 1.0
 * 8 August 2003
 */
global $gallery, $GALLERY_BASEDIR;

$GALLERY_BASEDIR = "/var/www_gallery/html/";
require_once($GALLERY_BASEDIR . "init.php");
define(ALBUM_BASEADDR, "http://gallery.kgadams.net/albums/");
define(CACHE_FILE, $gallery->app->albumDir . "/block-random.cache");   
define(SERVER_ADDR, "http://gallery.kgadams.net/");               
define(CACHE_EXPIRED, 86400);

function daily_photo(){
	global $gallery;
	if((fs_file_exists($gallery->app->albumDir."/daily.jpg"))){
		$stat=stat($gallery->app->albumDir."/daily.jpg");
		$modtime = $stat['mtime'];
		if(date("d", $modtime) != date("d", time())) {
			list($album,$index) = get_random_photo_id();
			list($url, $albumURL) = random_photo($album,$index,24);
            $content = "<center><a href=\"".$url."\"><img src=\"".ALBUM_BASEADDR."daily.jpg\" border=\"0\"></a></center>";
			$content .= "<br><center>From: <a href=\"".$albumURL."\">".$album->fields["title"]."</a></center>";
		}
		else{
            $fp = fs_fopen($gallery->app->albumDir."/daily.txt", "r");
            $line = explode("      ",fgets($fp, 4096));
            fclose($fp);
            $content = "<center><a href=\"".$line[0]."\"><img src=\"".ALBUM_BASEADDR."daily.jpg\" border=\"0\"></a></center>";
			$content .= "<br><center>From: <a href=\"".$line[1]."\">".$line[2]."</a></center>";
		}
      }
      else {
            list($album,$index) = get_random_photo_id();
           	list ($url, $albumURL) = random_photo($album,$index,24);
			$content = "<center><a href=\"".$url."\"><img src=\"".ALBUM_BASEADDR."daily.jpg\" border=\"0\"></a></center>";
			$content .= "<br><center>From: <a href=\"".$albumURL."\">".$album->fields["title"]."</a></center>";
      }
      return $content;
}
  
  function hourly_photo(){
	global $gallery;
	if((fs_file_exists($gallery->app->albumDir."/hourly.jpg"))){
		$stat=stat($gallery->app->albumDir."/hourly.jpg");
		$modtime = $stat['mtime'];
		if(date("G", $modtime) != date("G", time())) {
			list($album,$index) = get_random_photo_id();
			list($url, $albumURL) = random_photo($album,$index,1);
            $content = "<center><a href=\"".$url."\"><img src=\"".ALBUM_BASEADDR."hourly.jpg\" border=\"0\"></a></center>";
			$content .= "<br><center>From: <a href=\"".$albumURL."\">".$album->fields["title"]."</a></center>";
		}
		else{
            $fp = fs_fopen($gallery->app->albumDir."/hourly.txt", "r");
            $line = explode("      ",fgets($fp, 4096));
            fclose($fp);
            $content = "<center><a href=\"".$line[0]."\"><img src=\"".ALBUM_BASEADDR."hourly.jpg\" border=\"0\"></a></center>";
			$content .= "<br><center>From: <a href=\"".$line[1]."\">".$line[2]."</a></center>";
		}
      }
      else {
            list($album,$index) = get_random_photo_id();
           	list ($url, $albumURL) = random_photo($album,$index,1);
			$content = "<center><a href=\"".$url."\"><img src=\"".ALBUM_BASEADDR."hourly.jpg\" border=\"0\"></a></center>";
			$content .= "<br><center>From: <a href=\"".$albumURL."\">".$album->fields["title"]."</a></center>";
      }
      return $content;
  }
  
  function random_photo($album, $index,$filetype){
	global $gallery;
		if (isset($index)) {
			// KGA Rewrote $url and $albumURL
			// to work with native Gallery instead
			// of embedded phpNuke
			$id = $album->getPhotoId($index);
			$url = SERVER_ADDR;
			$url .= "".$album->fields["name"];
			$url .= "/" .$id;

			$albumURL = SERVER_ADDR;
			$albumURL .= "".$album->fields["name"];
			$content = "<center><a href=\"$url\">".$album->getThumbnailTag($index)."</a></center>";
			$caption = $album->getCaption($index);
			if ($caption) {
				if (strlen($caption) > 90) {
					$caption = substr($caption,0,90)." ...";
				}
				$content.="<br><center>".$caption."</center>";
			}
			$content .= "<br><center>From: <a href=\"".$albumURL."\">".$album->fields["title"]."</a></center>";

		} else {
			$content = "No photo chosen.";
		}
		if($filetype == 24) {
               
fs_copy($gallery->app->albumDir."/".$album->fields["name"]."/".$id.".thumb.jpg",$gallery->app->albumDir."/daily.jpg");
               $fp = fs_fopen($gallery->app->albumDir."/daily.txt","w");
               fwrite($fp,$url."      ".$albumURL."      ".$album->fields["title"]);
               fclose($fp);
               return array($url, $albumURL);
      	}
		else if($filetype == 1) {
               
fs_copy($gallery->app->albumDir."/".$album->fields["name"]."/".$id.".thumb.jpg",$gallery->app->albumDir."/hourly.jpg");
               $fp = fs_fopen($gallery->app->albumDir."/hourly.txt","w");
               fwrite($fp,$url."      ".$albumURL."      ".$album->fields["title"]);
               fclose($fp);
               return array($url, $albumURL);
      	}

        return $content;
  }

function get_random_photo_id(){
		/* Initializing the seed */
		srand ((double) microtime() * 1000000);

		// Check the cache file to see if it's up to date
		$rebuild = 0;
		if (fs_file_exists(CACHE_FILE)) {
			$stat = fs_stat(CACHE_FILE);
			$mtime = $stat[9];
			if (time() - $mtime < CACHE_EXPIRED) {
			$rebuild = 1;
			}
		}

		if (!$rebuild) {
			scanalbums();
			savecache();
		} else {
			readcache();
		}

		$album = choosealbum();

		if ($album) {
			$index = choosephoto($album);
		}
		return array($album,$index);
}

   /*
 * --------------------------------------------------
 * Support functions
 * --------------------------------------------------
 */

function savecache() {
    global $cache;
    if ($fd = fs_fopen(CACHE_FILE, "w")) {
	foreach ($cache as $key => $val) {
	    fwrite($fd, "$key/$val\n");
	}
	fclose($fd);
    }
}

function readcache() {
    global $cache;
    if ($fd = fs_fopen(CACHE_FILE, "r")) {
	while ($line = fgets($fd, 4096)) {
	    list($key, $val) = explode("/", $line);
	    $cache[$key] = $val;
	}
	fclose($fd);
    }
}

function choosephoto($album) {
    global $cache;

    $count = $cache[$album->fields["name"]];
	
    if ($count == 0) {
	// Shouldn't happen
	return null;
    } else if ($count == 1) {
	$choose = 1;
    } else {
		$count = floatval($count);
		$choose = rand(1, $count);
		$wrap = 0;
		if ($album->isHidden($choose)) {
			$choose++;
			if ($choose > $album->numPhotos(1)) {
			$choose = 1;
			$wrap++;

				if ($wrap = 2) {
					return null;
				}
			}
		}
    }

    return $choose;
}

function choosealbum() {
    global $cache;

    /*
     * The odds that an album will be selected is proportional
     * to the number of (visible) items in the album.
     */

    $total = 0;
    foreach ($cache as $name => $count) {
		if (!$choose) {
			$choose = $name;
		}

		$total += $count;
		if ($total != 0 && ($total == 1 || rand(1, $total) <= $count)) {
			$choose = $name;
		}
    }

    if ($choose) {
	$album = new Album();
	$album->load($choose);
	return $album;
    } else {
	return null;
    }
}

function scanalbums() {
    global $cache;
    global $gallery;

    $cache = array();
    $everybody = $gallery->userDB->getEverybody();
    $albumDB = new AlbumDB();
    foreach ($albumDB->albumList as $tmpAlbum) {
		if ($everybody->canReadAlbum($tmpAlbum)) {
			$seeHidden = $everybody->canWriteToAlbum($tmpAlbum);
			$numPhotos = $tmpAlbum->numPhotos($seeHidden);
			$name = $tmpAlbum->fields["name"];
			if ($numPhotos > 0) {
			$cache[$name] = $numPhotos;
			}
		}
    }
}
?>
